/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import net.comcraft.src.ModLoader;

public class Mod {
    public String info;
    public boolean running = false;
    private ModLoader ml;
    public String name;
    public String description;
    public String mainClass;
    public boolean enabled;
    public boolean fatalError;

    public Mod(ModLoader modLoader, String name) {
        this.ml = modLoader;
        this.name = name;
        this.enabled = true;
        this.fatalError = false;
    }

    public void initMod() {
        this.enabled = !this.ml.isDisabled(this.mainClass);
        this.runMain();
    }

    public void runMain() {
        if (this.running || !this.enabled || this.mainClass == null) {
            return;
        }
        int idx = this.mainClass.lastIndexOf(46);
        String mainPackage = this.mainClass.substring(0, idx);
        String fileName = this.mainClass.substring(idx + 1);
        try {
            this.ml.executeModInNs(mainPackage, fileName);
            this.running = true;
        }
        catch (Exception e) {
            this.fatalError = true;
            e.printStackTrace();
            this.info = String.valueOf(e.getMessage()) + "\n\nIn Mod " + this.mainClass;
        }
    }

    public void enable() {
        this.ml.enable(this.mainClass);
        this.enabled = true;
    }

    public void disable() {
        this.ml.disable(this.mainClass);
        this.enabled = false;
    }
}

