/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import net.comcraft.client.Comcraft;
import net.comcraft.src.FileSystemHelper;

public final class MusicPlayer {
    private Comcraft cc;
    private Vector musicList = new Vector(20);
    private Player player;
    private long nextPlayTime;
    private Random rand = new Random();
    private int lastMusic = -1;
    static /* synthetic */ Class class$0;

    public MusicPlayer(Comcraft cc) {
        this.cc = cc;
    }

    public void loadMusicList() {
        this.musicList.removeAllElements();
        this.musicList.addElement("/music/Comcraft.mp3");
        if (!this.cc.settings.getComcraftFileSystem().isAvailable()) {
            return;
        }
        this.loadMusicFromMainFolder();
    }

    private void loadMusicFromMainFolder() {
        try {
            FileConnection fileConnection = (FileConnection)Connector.open((String)this.cc.settings.getComcraftFileSystem().getPathToFolder("music/"), (int)1);
            Vector elements = FileSystemHelper.getElementsList(fileConnection);
            int i = 0;
            while (i < elements.size()) {
                String elementName = (String)elements.elementAt(i);
                if (elementName.endsWith(".mp3") || elementName.endsWith(".wav") || elementName.endsWith(".midi")) {
                    this.musicList.addElement(elementName);
                }
                ++i;
            }
            fileConnection.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void startPlayingMusic() {
        int i = this.rand.nextInt(this.musicList.size());
        if (this.musicList.size() > 1) {
            while (i == this.lastMusic) {
                i = this.rand.nextInt(this.musicList.size());
            }
        }
        this.lastMusic = i;
        String path = (String)this.musicList.elementAt(i);
        InputStream inputStream = null;
        if (path.startsWith("/")) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("net.comcraft.src.MusicPlayer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            inputStream = clazz.getResourceAsStream(path);
        } else {
            try {
                inputStream = Connector.openInputStream((String)path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                this.player = Manager.createPlayer((InputStream)inputStream, (String)MusicPlayer.getContentType(path));
                this.player.start();
                VolumeControl control = (VolumeControl)this.player.getControl("VolumeControl");
                control.setLevel(20);
            }
            catch (IOException ex) {
                this.player = null;
            }
            catch (MediaException ex) {
                this.player = null;
            }
        }
    }

    public static String getContentType(String path) {
        if (path.endsWith(".mp3")) {
            return "audio/mpeg";
        }
        if (path.endsWith(".wav")) {
            return "audio/x-wav";
        }
        if (path.endsWith(".midi")) {
            return "audio/midi";
        }
        return "";
    }

    public void tickMusicPlayer() {
        if (this.cc.isGamePaused || !this.cc.settings.sounds) {
            if (this.player != null) {
                try {
                    this.player.stop();
                }
                catch (MediaException mediaException) {
                    // empty catch block
                }
                this.player.close();
                this.player = null;
            }
        } else {
            long currentTime = System.currentTimeMillis();
            if (this.player == null) {
                if (currentTime > this.nextPlayTime && !this.musicList.isEmpty()) {
                    this.startPlayingMusic();
                }
            } else if (this.player.getState() == 300) {
                this.player.close();
                this.nextPlayTime = currentTime + (long)(this.rand.nextInt(20) * 1000) + 15000L;
                this.player = null;
            }
        }
    }
}

