/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.util.Vector;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Fog;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Material;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.VertexBuffer;
import net.comcraft.client.Comcraft;
import net.comcraft.src.Block;
import net.comcraft.src.ChunkPiece;
import net.comcraft.src.EntityPlayer;

public final class RenderBlocks {
    private final Comcraft cc;
    private Graphics3D g3D;
    private Appearance[] appearanceList;
    private Appearance[] skinList;
    private Fog fog;
    private boolean renderAllFaces;
    private Vector cullingOffTextures;

    public RenderBlocks(Comcraft cc) {
        this.cc = cc;
        this.fog = new Fog();
        this.g3D = Graphics3D.getInstance();
        this.cullingOffTextures = new Vector(20);
        this.addCullingOffTextures(Block.getBlock("redFlower").getUsedTexturesList());
        this.addCullingOffTextures(Block.getBlock("yellowFlower").getUsedTexturesList());
        this.addCullingOffTextures(Block.getBlock("treePlant").getUsedTexturesList());
        this.addCullingOffTextures(Block.getBlock("toadstool").getUsedTexturesList());
        this.addCullingOffTextures(Block.getBlock("mushroom").getUsedTexturesList());
        this.addCullingOffTextures(Block.getBlock("wheat").getUsedTexturesList());
    }

    private void addCullingOffTextures(int[] list) {
        int n = 0;
        while (n < list.length) {
            Integer i = new Integer(list[n]);
            this.cullingOffTextures.addElement(i);
            ++n;
        }
    }

    public void releaseRenderBlock() {
        this.appearanceList = null;
        this.skinList = null;
    }

    public void reloadRenderBlock() {
        this.appearanceList = new Appearance[512];
        this.skinList = new Appearance[6];
        Material material = new Material();
        material.setVertexColorTrackingEnable(false);
        CompositingMode compositingMode = new CompositingMode();
        compositingMode.setBlending(64);
        compositingMode.setAlphaThreshold(0.1f);
        PolygonMode polygonModeNormal = new PolygonMode();
        polygonModeNormal.setPerspectiveCorrectionEnable(this.cc.settings.fancyGraphics);
        polygonModeNormal.setShading(164);
        polygonModeNormal.setCulling(160);
        polygonModeNormal.setLocalCameraLightingEnable(false);
        polygonModeNormal.setTwoSidedLightingEnable(false);
        PolygonMode polygonModeCullingOff = new PolygonMode();
        polygonModeCullingOff.setPerspectiveCorrectionEnable(this.cc.settings.fancyGraphics);
        polygonModeCullingOff.setShading(164);
        polygonModeCullingOff.setCulling(162);
        polygonModeCullingOff.setLocalCameraLightingEnable(false);
        polygonModeCullingOff.setTwoSidedLightingEnable(false);
        this.setFogColor(11591910);
        this.setFogDistance(130.0f);
        int i = 0;
        while (i < this.appearanceList.length) {
            this.appearanceList[i] = new Appearance();
            this.appearanceList[i].setTexture(0, this.cc.textureProvider.getTerrainTexture(i));
            this.appearanceList[i].setMaterial(material);
            this.appearanceList[i].setCompositingMode(compositingMode);
            if (this.cc.settings.fog) {
                this.appearanceList[i].setFog(this.fog);
            }
            if (this.cullingOffTextures.contains(new Integer(i))) {
                this.appearanceList[i].setPolygonMode(polygonModeCullingOff);
            } else {
                this.appearanceList[i].setPolygonMode(polygonModeNormal);
            }
            ++i;
        }
        i = 0;
        while (i < this.skinList.length) {
            this.skinList[i] = new Appearance();
            this.skinList[i].setTexture(0, this.cc.textureProvider.getSkinTexture(i));
            this.skinList[i].setMaterial(material);
            this.skinList[i].setCompositingMode(compositingMode);
            this.skinList[i].setPolygonMode(polygonModeNormal);
            ++i;
        }
    }

    public void setFogColor(int color) {
        this.fog.setColor(color);
    }

    public void setFogDistance(float distance) {
        this.fog.setLinear(distance - (float)(this.cc.settings.renderDistance * 5), distance);
    }

    public void renderBlockAllFaces(Block block, int x, int y, int z, Transform transform) {
        this.renderAllFaces = true;
        this.renderBlockByRenderType(block, x, y, z, transform, null, null);
        this.renderAllFaces = false;
    }

    public void renderBlockByRenderType(Block block, int x, int y, int z, Transform transform, EntityPlayer player, ChunkPiece chunkPiece) {
        int i = block.getRenderType();
        if (i == 0 || (i == 1 || i == 4 || i == 10) && chunkPiece == null) {
            this.renderStandardBlock(block, x, y, z, transform, player);
        } else if (i == 1) {
            this.renderPiecedBlock(block, x, y, z, transform, player, chunkPiece);
        } else if (i == 2) {
            this.renderFlowerBlock(block, x, y, z, transform);
        } else if (i == 3) {
            this.renderLiquidBlock(block, x, y, z, transform, player);
        } else if (i == 4) {
            this.renderCarpetBlock(block, x, y, z, transform, player, chunkPiece);
        } else if (i == 5) {
            this.renderTorchBlock(block, x, y, z, transform, player);
        } else if (i == 6) {
            this.renderModelBlock(block, x, y, z, transform);
        } else if (i == 7) {
            this.renderStairsBlock(block, x, y, z, transform, player);
        } else if (i == 8) {
            this.renderFenceBlock(block, x, y, z, transform, player);
        } else if (i == 9) {
            this.renderBedBlock(block, x, y, z, transform, player);
        } else if (i == 10) {
            this.renderPlayerBlock(block, x, y, z, transform, player, chunkPiece);
        }
    }

    private void renderFenceBlock(Block block, int x, int y, int z, Transform transform, EntityPlayer player) {
        int n = 0;
        while (n < 12) {
            if (block.shouldSideBeRendered(this.cc.world, x, y, z, n) || this.renderAllFaces && n < 6) {
                this.renderFenceFace(block, x, y, z, n, transform);
            }
            ++n;
        }
    }

    private void renderFenceFace(Block block, int x, int y, int z, int side, Transform transform) {
        VertexBuffer[] blockVertexBuffer = block.getBlockVertexBufferSided(this.cc.world, x, y, z);
        Transform transform1 = block.getBlockTransform(this.cc.world, x, y, z, transform, side);
        if (blockVertexBuffer != null) {
            this.g3D.render(blockVertexBuffer[side % 6], block.getBlockIndexBuffer(), this.appearanceList[block.getBlockTexture(this.cc.world, x, y, z, side)], transform1);
        }
    }

    private void renderStairsBlock(Block block, int x, int y, int z, Transform transform, EntityPlayer player) {
        this.renderTransformedFace(block, x, y, z, 0, transform);
        this.renderTransformedFace(block, x, y, z, 1, transform);
        this.renderTransformedFace(block, x, y, z, 2, transform);
        this.renderTransformedFace(block, x, y, z, 3, transform);
        if (this.renderAllFaces || player.yPos > (float)y + 0.5f) {
            this.renderTransformedFace(block, x, y, z, 4, transform);
        }
        if (this.renderAllFaces || player.yPos < (float)y && block.shouldSideBeRendered(this.cc.world, x, y - 1, z, 5)) {
            this.renderTransformedFace(block, x, y, z, 5, transform);
        }
        this.renderTransformedFace(block, x, y, z, 6, transform);
        this.renderTransformedFace(block, x, y, z, 7, transform);
        this.renderTransformedFace(block, x, y, z, 8, transform);
        this.renderTransformedFace(block, x, y, z, 9, transform);
        if (this.renderAllFaces || player.yPos > (float)(y + 1) && block.shouldSideBeRendered(this.cc.world, x, y + 1, z, 10)) {
            this.renderTransformedFace(block, x, y, z, 10, transform);
        }
    }

    private void renderModelBlock(Block block, int x, int y, int z, Transform transform) {
        Node node = block.getBlockModel(this.cc.world, x, y, z);
        if (node != null) {
            this.g3D.render(node, transform);
        }
    }

    private void renderTorchBlock(Block block, int x, int y, int z, Transform transform, EntityPlayer player) {
        if (this.renderAllFaces || block.shouldSideBeRendered(this.cc.world, x, y, z + 1, 0)) {
            this.renderTransformedFace(block, x, y, z, 0, transform);
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.cc.world, x, y, z - 1, 1)) {
            this.renderTransformedFace(block, x, y, z, 1, transform);
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.cc.world, x - 1, y, z, 2)) {
            this.renderTransformedFace(block, x, y, z, 2, transform);
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.cc.world, x + 1, y, z, 3)) {
            this.renderTransformedFace(block, x, y, z, 3, transform);
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.cc.world, x, y + 1, z, 4)) {
            this.renderTransformedFace(block, x, y, z, 4, transform);
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.cc.world, x, y - 1, z, 5)) {
            this.renderTransformedFace(block, x, y, z, 5, transform);
        }
    }

    private void renderTransformedFace(Block block, int x, int y, int z, int side, Transform transform) {
        VertexBuffer[] blockVertexBuffer = block.getBlockVertexBufferSided(this.cc.world, x, y, z);
        Transform transform1 = block.getBlockTransform(this.cc.world, x, y, z, transform, side);
        if (blockVertexBuffer != null) {
            this.g3D.render(blockVertexBuffer[side], block.getBlockIndexBuffer(), this.appearanceList[block.getBlockTexture(this.cc.world, x, y, z, side)], transform1);
        }
    }

    private void renderCarpetBlock(Block block, int x, int y, int z, Transform transform, EntityPlayer player, ChunkPiece chunkPiece) {
        if (this.renderAllFaces || player.zPos > (float)z + 0.5f && block.shouldSideBeRendered(this.cc.world, x, y, z + 1, 0)) {
            this.renderPiecedFace(block, x, y, z, 0, chunkPiece, transform);
        }
        if (this.renderAllFaces || player.zPos < (float)z + 0.5f && block.shouldSideBeRendered(this.cc.world, x, y, z - 1, 1)) {
            this.renderPiecedFace(block, x, y, z, 1, chunkPiece, transform);
        }
        if (this.renderAllFaces || player.xPos < (float)x + 0.5f && block.shouldSideBeRendered(this.cc.world, x - 1, y, z, 2)) {
            this.renderPiecedFace(block, x, y, z, 2, chunkPiece, transform);
        }
        if (this.renderAllFaces || player.xPos > (float)x + 0.5f && block.shouldSideBeRendered(this.cc.world, x + 1, y, z, 3)) {
            this.renderPiecedFace(block, x, y, z, 3, chunkPiece, transform);
        }
        if (this.renderAllFaces || player.yPos > (float)y + 0.1f && block.shouldSideBeRendered(this.cc.world, x, y + 1, z, 4)) {
            this.renderPiecedFace(block, x, y, z, 4, chunkPiece, transform);
        }
        if (this.renderAllFaces || player.yPos < (float)y + 0.0f && block.shouldSideBeRendered(this.cc.world, x, y - 1, z, 5)) {
            this.renderPiecedFace(block, x, y, z, 5, chunkPiece, transform);
        }
    }

    private void renderFlowerBlock(Block block, int x, int y, int z, Transform transform) {
        this.renderStandardFace(block, x, y, z, 0, transform);
        this.renderStandardFace(block, x, y, z, 1, transform);
    }

    private void renderBedBlock(Block block, int x, int y, int z, Transform transform, EntityPlayer player) {
        if (this.renderAllFaces || player.zPos > (float)z + 1.0f && block.shouldSideBeRendered(this.cc.world, x, y, z + 1, 0)) {
            this.renderStandardFace(block, x, y, z, 0, transform);
        }
        if (this.renderAllFaces || player.zPos < (float)z + 0.0f && block.shouldSideBeRendered(this.cc.world, x, y, z - 1, 1)) {
            this.renderStandardFace(block, x, y, z, 1, transform);
        }
        if (this.renderAllFaces || player.xPos < (float)x + 0.0f && block.shouldSideBeRendered(this.cc.world, x - 1, y, z, 2)) {
            this.renderStandardFace(block, x, y, z, 2, transform);
        }
        if (this.renderAllFaces || player.xPos > (float)x + 1.0f && block.shouldSideBeRendered(this.cc.world, x + 1, y, z, 3)) {
            this.renderStandardFace(block, x, y, z, 3, transform);
        }
        if (this.renderAllFaces || player.yPos > (float)y + 0.5f && block.shouldSideBeRendered(this.cc.world, x, y + 1, z, 4)) {
            this.renderStandardFace(block, x, y, z, 4, transform);
        }
        if (this.renderAllFaces || player.yPos < (float)y + 0.0f && block.shouldSideBeRendered(this.cc.world, x, y - 1, z, 5)) {
            this.renderStandardFace(block, x, y, z, 5, transform);
        }
    }

    private void renderStandardBlock(Block block, int x, int y, int z, Transform transform, EntityPlayer player) {
        if (this.renderAllFaces || player.zPos > (float)z + 1.0f && block.shouldSideBeRendered(this.cc.world, x, y, z + 1, 0)) {
            this.renderStandardFace(block, x, y, z, 0, transform);
        }
        if (this.renderAllFaces || player.zPos < (float)z + 0.0f && block.shouldSideBeRendered(this.cc.world, x, y, z - 1, 1)) {
            this.renderStandardFace(block, x, y, z, 1, transform);
        }
        if (this.renderAllFaces || player.xPos < (float)x + 0.0f && block.shouldSideBeRendered(this.cc.world, x - 1, y, z, 2)) {
            this.renderStandardFace(block, x, y, z, 2, transform);
        }
        if (this.renderAllFaces || player.xPos > (float)x + 1.0f && block.shouldSideBeRendered(this.cc.world, x + 1, y, z, 3)) {
            this.renderStandardFace(block, x, y, z, 3, transform);
        }
        if (this.renderAllFaces || player.yPos > (float)y + 1.0f && block.shouldSideBeRendered(this.cc.world, x, y + 1, z, 4)) {
            this.renderStandardFace(block, x, y, z, 4, transform);
        }
        if (this.renderAllFaces || player.yPos < (float)y + 0.0f && block.shouldSideBeRendered(this.cc.world, x, y - 1, z, 5)) {
            this.renderStandardFace(block, x, y, z, 5, transform);
        }
    }

    private void renderLiquidBlock(Block block, int x, int y, int z, Transform transform, EntityPlayer player) {
        if (this.renderAllFaces || player.zPos > (float)z + 1.0f && block.shouldSideBeRendered(this.cc.world, x, y, z + 1, 0)) {
            this.renderStandardFace(block, x, y, z, 0, transform);
        }
        if (this.renderAllFaces || player.zPos < (float)z + 0.0f && block.shouldSideBeRendered(this.cc.world, x, y, z - 1, 1)) {
            this.renderStandardFace(block, x, y, z, 1, transform);
        }
        if (this.renderAllFaces || player.xPos < (float)x + 0.0f && block.shouldSideBeRendered(this.cc.world, x - 1, y, z, 2)) {
            this.renderStandardFace(block, x, y, z, 2, transform);
        }
        if (this.renderAllFaces || player.xPos > (float)x + 1.0f && block.shouldSideBeRendered(this.cc.world, x + 1, y, z, 3)) {
            this.renderStandardFace(block, x, y, z, 3, transform);
        }
        if (this.renderAllFaces || player.yPos > (float)y + 0.0f && block.shouldSideBeRendered(this.cc.world, x, y + 1, z, 4)) {
            this.renderStandardFace(block, x, y, z, 4, transform);
        }
        if (this.renderAllFaces || player.yPos < (float)y + 0.0f && block.shouldSideBeRendered(this.cc.world, x, y - 1, z, 5)) {
            this.renderStandardFace(block, x, y, z, 5, transform);
        }
    }

    private void renderStandardFace(Block block, int x, int y, int z, int side, Transform transform) {
        VertexBuffer[] blockVertexBuffer = block.getBlockVertexBufferSided(this.cc.world, x, y, z);
        if (blockVertexBuffer != null) {
            this.g3D.render(blockVertexBuffer[side], block.getBlockIndexBuffer(), this.appearanceList[block.getBlockTexture(this.cc.world, x, y, z, side)], transform);
        }
    }

    private void renderPiecedBlock(Block block, int x, int y, int z, Transform transform, EntityPlayer player, ChunkPiece chunkPiece) {
        if (this.renderAllFaces || player.zPos > (float)z + 1.0f && block.shouldSideBeRendered(this.cc.world, x, y, z + 1, 0)) {
            this.renderPiecedFace(block, x, y, z, 0, chunkPiece, transform);
        }
        if (this.renderAllFaces || player.zPos < (float)z + 0.0f && block.shouldSideBeRendered(this.cc.world, x, y, z - 1, 1)) {
            this.renderPiecedFace(block, x, y, z, 1, chunkPiece, transform);
        }
        if (this.renderAllFaces || player.xPos < (float)x + 0.0f && block.shouldSideBeRendered(this.cc.world, x - 1, y, z, 2)) {
            this.renderPiecedFace(block, x, y, z, 2, chunkPiece, transform);
        }
        if (this.renderAllFaces || player.xPos > (float)x + 1.0f && block.shouldSideBeRendered(this.cc.world, x + 1, y, z, 3)) {
            this.renderPiecedFace(block, x, y, z, 3, chunkPiece, transform);
        }
        if (this.renderAllFaces || player.yPos > (float)y + 1.0f && block.shouldSideBeRendered(this.cc.world, x, y + 1, z, 4)) {
            this.renderPiecedFace(block, x, y, z, 4, chunkPiece, transform);
        }
        if (this.renderAllFaces || player.yPos < (float)y + 0.0f && block.shouldSideBeRendered(this.cc.world, x, y - 1, z, 5)) {
            this.renderPiecedFace(block, x, y, z, 5, chunkPiece, transform);
        }
    }

    private void renderPlayerBlock(Block block, int x, int y, int z, Transform transform, EntityPlayer player, ChunkPiece chunkPiece) {
        if (this.renderAllFaces || player.zPos > (float)z + 1.0f && block.shouldSideBeRendered(this.cc.world, x, y, z + 1, 0)) {
            this.renderPlayerFace(block, x, y, z, 0, chunkPiece, transform);
        }
        if (this.renderAllFaces || player.zPos < (float)z + 0.0f && block.shouldSideBeRendered(this.cc.world, x, y, z - 1, 1)) {
            this.renderPlayerFace(block, x, y, z, 1, chunkPiece, transform);
        }
        if (this.renderAllFaces || player.xPos < (float)x + 0.0f && block.shouldSideBeRendered(this.cc.world, x - 1, y, z, 2)) {
            this.renderPlayerFace(block, x, y, z, 2, chunkPiece, transform);
        }
        if (this.renderAllFaces || player.xPos > (float)x + 1.0f && block.shouldSideBeRendered(this.cc.world, x + 1, y, z, 3)) {
            this.renderPlayerFace(block, x, y, z, 3, chunkPiece, transform);
        }
        if (this.renderAllFaces || player.yPos > (float)y + 2.0f && block.shouldSideBeRendered(this.cc.world, x, y + 1, z, 4)) {
            this.renderPlayerFace(block, x, y, z, 4, chunkPiece, transform);
        }
        if (this.renderAllFaces || player.yPos < (float)y + 0.0f && block.shouldSideBeRendered(this.cc.world, x, y - 1, z, 5)) {
            this.renderPlayerFace(block, x, y, z, 5, chunkPiece, transform);
        }
    }

    private void renderPlayerFace(Block block, int x, int y, int z, int side, ChunkPiece chunkPiece, Transform transform) {
        if (chunkPiece.needsRender(this.cc.render.currentTick, side)) {
            this.g3D.render(chunkPiece.getVertexBuffer(this.cc.world, side), block.getBlockIndexBuffer(), this.skinList[block.getBlockTexture(this.cc.world, x, y, z, side)], transform);
        }
    }

    private void renderPiecedFace(Block block, int x, int y, int z, int side, ChunkPiece chunkPiece, Transform transform) {
        if (chunkPiece.needsRender(this.cc.render.currentTick, side)) {
            this.g3D.render(chunkPiece.getVertexBuffer(this.cc.world, side), block.getBlockIndexBuffer(), this.appearanceList[block.getBlockTexture(this.cc.world, x, y, z, side)], transform);
        }
    }
}

