/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import com.google.minijoe.sys.JsArray;
import com.google.minijoe.sys.JsObject;
import java.util.Vector;
import net.comcraft.client.Comcraft;
import net.comcraft.src.AxisAlignedBB;
import net.comcraft.src.Block;
import net.comcraft.src.Chunk;
import net.comcraft.src.ChunkLoader;
import net.comcraft.src.ChunkManager;
import net.comcraft.src.GuiLoadingWorld;
import net.comcraft.src.LevelInfo;
import net.comcraft.src.LoadingScreen;
import net.comcraft.src.RayObjectPosition;
import net.comcraft.src.Vec3D;
import net.comcraft.src.WorldInfo;
import net.comcraft.src.WorldUpdater;

public final class World
extends JsObject {
    public int worldSize;
    public final Comcraft cc;
    public ChunkManager chunkProvider;
    private LevelInfo saveInfo;
    private WorldInfo worldInfo;
    private long lastAutosaveTime;
    private WorldUpdater worldUpdater;
    public long startTime;
    private static final int ID_GET_BLOCK_BOUNDING_BOX = 100;
    private static final int ID_IS_AIR_BLOCK = 101;
    private static final int ID_GET_BLOCK = 102;
    private static final int ID_GET_BLOCK_ID = 103;
    private static final int ID_GET_BLOCK_METADATA = 104;
    private static final int ID_SET_BLOCK_AND_METADATA = 105;
    private static final int ID_SET_BLOCK_ID = 106;
    private static final int ID_SET_BLOCK_N = 107;
    private static final int ID_SET_BLOCK_AND_METADATA_N = 108;
    private static final int ID_SET_BLOCK_METADATA = 109;
    private static final int ID_IS_BLOCK_NORMAL = 110;
    private static final int ID_NOTIFY_BLOCKS = 111;
    private static final int ID_NOTIFY_BLOCKS_OF_NEIGHBOR_CHANGE = 112;
    private static final int ID_CAN_BLOCK_BE_PLACED_AT = 113;

    public World(Comcraft cc, LevelInfo saveHandler) {
        super(JsObject.OBJECT_PROTOTYPE);
        this.cc = cc;
        this.saveInfo = saveHandler;
        this.worldInfo = saveHandler.loadWorldInfo(cc.player);
        this.worldSize = this.worldInfo.getWorldSize();
        this.chunkProvider = this.createChunkProvider();
        this.worldUpdater = new WorldUpdater(this);
        this.startTime = System.currentTimeMillis();
        this.addNative("getBlockBoundingBox", 100, 3);
        this.addNative("isAirBlock", 101, 3);
        this.addNative("getBlock", 102, 3);
        this.addNative("getBlockID", 103, 3);
        this.addNative("getBlockMetadata", 104, 3);
        this.addNative("setBlockAndMetadata", 105, 5);
        this.addNative("setBlockID", 106, 4);
        this.addNative("setBlockN", 107, 4);
        this.addNative("setBlockAndMetadataN", 108, 5);
        this.addNative("setBlockMetadata", 109, 4);
        this.addNative("isBlockNormal", 110, 3);
        this.addNative("notifyBlocks", 111, 4);
        this.addNative("notifyBlocksOfNeighborChange", 112, 4);
        this.addNative("canBlockBePlacedAt", 113, 5);
        this.addVar("worldSize", new Integer(this.worldSize));
    }

    public WorldUpdater getWorldUpdater() {
        return this.worldUpdater;
    }

    public void checkAutosave() {
        if (this.lastAutosaveTime == 0L) {
            this.lastAutosaveTime = this.cc.currentTime;
        }
        if (this.cc.currentTime - this.lastAutosaveTime > (long)this.cc.settings.autosaveTime) {
            this.saveWorld(null);
            this.lastAutosaveTime = this.cc.currentTime;
        }
    }

    public void loadAllChunks() {
        int z = 0;
        while (z < this.worldSize) {
            int x = 0;
            while (x < this.worldSize) {
                this.getChunkFromChunkCoords(x, z);
                ++x;
            }
            ++z;
        }
        this.cc.displayGuiScreen(new GuiLoadingWorld());
    }

    public void updateCurrentChunksList(Vector currentChunksList) {
        currentChunksList.removeAllElements();
        int renderDistance = this.cc.settings.renderDistance;
        int z = -renderDistance;
        while (z <= renderDistance) {
            int x = -renderDistance;
            while (x <= renderDistance) {
                Chunk chunk = this.cc.world.getChunkFromBlockCoords((int)this.cc.player.xPos + (x << 2), (int)this.cc.player.zPos + (z << 2));
                currentChunksList.addElement(chunk);
                ++x;
            }
            ++z;
        }
    }

    public void saveWorld(LoadingScreen loadingScreen) {
        if (loadingScreen != null) {
            loadingScreen.displayLoadingScreen(this.cc.langBundle.getText("GuiLoading.savingWorldText"));
        }
        this.saveInfo.saveWorldInfo(this.worldInfo, this.cc.player);
        this.chunkProvider.saveAllChunks(loadingScreen);
    }

    public ChunkManager createChunkProvider() {
        ChunkLoader chunkLoader = this.saveInfo.getChunkLoader(this);
        return new ChunkManager(this.cc, chunkLoader, this);
    }

    public void onWorldEnd() {
        this.chunkProvider.onChunkProviderEnd();
    }

    public AxisAlignedBB getBlockBoundingBox(int x, int y, int z) {
        int id = this.getBlockID(x, y, z);
        if (Block.blocksList[id] == null) {
            return null;
        }
        return Block.blocksList[id].getCollisionBoundingBoxFromPool(this, x, y, z);
    }

    public boolean isAirBlock(int x, int y, int z) {
        return this.getBlockID(x, y, z) == 0;
    }

    public Chunk getChunkFromBlockCoords(int x, int z) {
        return this.getChunkFromChunkCoords(x >> 2, z >> 2);
    }

    public Chunk getChunkFromChunkCoords(int x, int z) {
        return this.chunkProvider.getChunk(x, z);
    }

    public Block getBlock(int x, int y, int z) {
        return Block.blocksList[this.getBlockID(x, y, z)];
    }

    public int getBlockID(int x, int y, int z) {
        if (x < 0 || z < 0 || x >= this.worldSize << 2 || z >= this.worldSize << 2) {
            return 1;
        }
        if (y < 0 || y >= 32) {
            return 0;
        }
        return this.getChunkFromChunkCoords(x >> 2, z >> 2).getBlockID(x & 3, y, z & 3);
    }

    public int getBlockMetadata(int x, int y, int z) {
        if (x < 0 || z < 0 || x >= this.worldSize << 2 || z >= this.worldSize << 2) {
            return 0;
        }
        if (y < 0 || y >= 32) {
            return 0;
        }
        return this.getChunkFromChunkCoords(x >> 2, z >> 2).getBlockMetadata(x & 3, y, z & 3);
    }

    public boolean setBlockAndMetadata(int x, int y, int z, int id, int metadata) {
        if (x < 0 || z < 0 || x >= this.worldSize << 2 || z >= this.worldSize << 2 || y < 0 || y >= 32) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(x >> 2, z >> 2);
        return chunk.setBlockIDWithMetadata(x & 3, y, z & 3, id, metadata);
    }

    public boolean setBlockID(int x, int y, int z, int id) {
        if (x < 0 || z < 0 || x >= this.worldSize << 2 || z >= this.worldSize << 2 || y < 0 || y >= 32) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(x >> 2, z >> 2);
        return chunk.setBlockID(x & 3, y, z & 3, id);
    }

    public boolean setBlockN(int x, int y, int z, int id) {
        if (this.setBlockID(x, y, z, id)) {
            this.notifyBlocks(x, y, z, id);
            return true;
        }
        return false;
    }

    public boolean setBlockAndMetadataN(int x, int y, int z, int id, int metadata) {
        if (this.setBlockAndMetadata(x, y, z, id, metadata)) {
            this.notifyBlocks(x, y, z, id);
            return true;
        }
        return false;
    }

    public boolean setBlockMetadata(int x, int y, int z, int metadata) {
        if (x < 0 || z < 0 || x >= this.worldSize << 2 || z >= this.worldSize << 2 || y < 0 || y >= 32) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(x >> 2, z >> 2);
        return chunk.setBlockMetadata(x & 3, y, z & 3, metadata);
    }

    public boolean isBlockNormal(int par1, int par2, int par3) {
        Block block = Block.blocksList[this.getBlockID(par1, par2, par3)];
        if (block == null) {
            return false;
        }
        return block.isNormal();
    }

    public void notifyBlocks(int x, int y, int z, int blockId) {
        this.notifyBlocksOfNeighborChange(x, y, z, blockId);
    }

    public void notifyBlocksOfNeighborChange(int x, int y, int z, int blockID) {
        this.notifyBlockOfNeighborChange(x - 1, y, z, blockID);
        this.notifyBlockOfNeighborChange(x + 1, y, z, blockID);
        this.notifyBlockOfNeighborChange(x, y - 1, z, blockID);
        this.notifyBlockOfNeighborChange(x, y + 1, z, blockID);
        this.notifyBlockOfNeighborChange(x, y, z - 1, blockID);
        this.notifyBlockOfNeighborChange(x, y, z + 1, blockID);
    }

    private void notifyBlockOfNeighborChange(int x, int y, int z, int blockID) {
        Block block = Block.blocksList[this.getBlockID(x, y, z)];
        if (block != null) {
            block.onNeighborBlockChange(this, x, y, z, blockID);
        }
    }

    public RayObjectPosition rayTraceBlocks(Vec3D startVec, Vec3D lookVec, float distance) {
        Vec3D currentVec = new Vec3D(startVec);
        int accuracy = 15;
        lookVec = new Vec3D(-lookVec.x / 15.0f, lookVec.y / 15.0f, -lookVec.z / 15.0f);
        while (currentVec.distanceTo(startVec) <= distance) {
            currentVec = currentVec.addVector(lookVec);
            int inX = (int)currentVec.x;
            int inY = (int)currentVec.y;
            int inZ = (int)currentVec.z;
            int id = this.getBlockID(inX, inY, inZ);
            if (this.getChunkFromBlockCoords(inX, inZ).isEmptyChunk()) {
                return null;
            }
            if (id == 0 || !Block.blocksList[id].getCollisionBoundingBoxFromPool(this, inX, inY, inZ).isVecInside(currentVec)) continue;
            return this.getMovingObjectPosition(currentVec, lookVec);
        }
        return null;
    }

    private RayObjectPosition getMovingObjectPosition(Vec3D currentVec, Vec3D lookVec) {
        Vec3D lastVec = lookVec.subtractVector(currentVec);
        int x = (int)currentVec.x;
        int y = (int)currentVec.y;
        int z = (int)currentVec.z;
        int xL = (int)lastVec.x;
        int yL = (int)lastVec.y;
        int zL = (int)lastVec.z;
        int side = -1;
        if (zL > z) {
            side = 0;
        } else if (zL < z) {
            side = 1;
        } else if (xL > x) {
            side = 2;
        } else if (xL < x) {
            side = 3;
        } else if (yL > y) {
            side = 4;
        } else if (yL < y) {
            side = 5;
        }
        return new RayObjectPosition(x, y, z, side, currentVec);
    }

    public boolean canBlockBePlacedAt(int id, int x, int y, int z, int side) {
        Block block = Block.blocksList[id];
        if (block != null) {
            AxisAlignedBB axisalignedbb = block.getCollisionBoundingBoxFromPool(this, x, y, z);
            if (this.cc.player.getBoundingBox().collidesWith(axisalignedbb)) {
                return false;
            }
        }
        return id > 0 && block.canPlaceBlockOnSide(this, x, y, z, side);
    }

    public void evalNative(int id, JsArray stack, int sp, int parCount) {
        switch (id) {
            case 100: {
                stack.setObject(sp, (Object)this.getBlockBoundingBox(stack.getInt(sp + 2), stack.getInt(sp + 3), stack.getInt(sp + 4)));
                break;
            }
            case 101: {
                stack.setBoolean(sp, this.isAirBlock(stack.getInt(sp + 2), stack.getInt(sp + 3), stack.getInt(sp + 4)));
                break;
            }
            case 102: {
                stack.setObject(sp, (Object)this.getBlock(stack.getInt(sp + 2), stack.getInt(sp + 3), stack.getInt(sp + 4)));
                break;
            }
            case 103: {
                stack.setInt(sp, this.getBlockID(stack.getInt(sp + 2), stack.getInt(sp + 3), stack.getInt(sp + 4)));
                break;
            }
            case 104: {
                stack.setInt(sp, this.getBlockMetadata(stack.getInt(sp + 2), stack.getInt(sp + 3), stack.getInt(sp + 4)));
                break;
            }
            case 105: {
                stack.setBoolean(sp, this.setBlockAndMetadata(stack.getInt(sp + 2), stack.getInt(sp + 3), stack.getInt(sp + 4), stack.getInt(sp + 5), stack.getInt(sp + 6)));
                break;
            }
            case 106: {
                stack.setBoolean(sp, this.setBlockID(stack.getInt(sp + 2), stack.getInt(sp + 3), stack.getInt(sp + 4), stack.getInt(sp + 5)));
                break;
            }
            case 107: {
                stack.setBoolean(sp, this.setBlockN(stack.getInt(sp + 2), stack.getInt(sp + 3), stack.getInt(sp + 4), stack.getInt(sp + 5)));
                break;
            }
            case 108: {
                stack.setBoolean(sp, this.setBlockAndMetadataN(stack.getInt(sp + 2), stack.getInt(sp + 3), stack.getInt(sp + 4), stack.getInt(sp + 5), stack.getInt(sp + 6)));
                break;
            }
            case 109: {
                stack.setBoolean(sp, this.setBlockMetadata(stack.getInt(sp + 2), stack.getInt(sp + 3), stack.getInt(sp + 4), stack.getInt(sp + 5)));
                break;
            }
            case 110: {
                stack.setBoolean(sp, this.isBlockNormal(stack.getInt(sp + 2), stack.getInt(sp + 3), stack.getInt(sp + 4)));
                break;
            }
            case 111: {
                this.notifyBlocks(stack.getInt(sp + 2), stack.getInt(sp + 3), stack.getInt(sp + 4), stack.getInt(sp + 5));
                break;
            }
            case 112: {
                this.notifyBlocksOfNeighborChange(stack.getInt(sp + 2), stack.getInt(sp + 3), stack.getInt(sp + 4), stack.getInt(sp + 5));
                break;
            }
            case 113: {
                stack.setBoolean(sp, this.canBlockBePlacedAt(stack.getInt(sp + 2), stack.getInt(sp + 3), stack.getInt(sp + 4), stack.getInt(sp + 5), stack.getInt(sp + 6)));
                break;
            }
            default: {
                super.evalNative(id, stack, sp, parCount);
            }
        }
    }
}

