/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import javax.microedition.m3g.VertexBuffer;
import net.comcraft.src.AxisAlignedBB;
import net.comcraft.src.Block;
import net.comcraft.src.ModelLiquid;
import net.comcraft.src.World;

public class BlockLiquid
extends Block {
    private int waterFall = 1;

    public BlockLiquid(int id, int textureIndex) {
        super(id, textureIndex);
    }

    public boolean doesBlockDestroyGrass() {
        return false;
    }

    public boolean isReplaceableBlock() {
        return true;
    }

    public BlockLiquid setWaterFall(int waterFall) {
        this.waterFall = waterFall;
        return this;
    }

    public boolean isUpdatableBlock() {
        return true;
    }

    public boolean shouldSideBeRendered(World world, int x, int y, int z, int side) {
        return world.getBlockID(x, y, z) == 0 || world.getBlockID(x, y, z) != 0 && side == 4 || !Block.blocksList[world.getBlockID(x, y, z)].isNormal() || world.getBlockID(x, y, z) == this.blockID && this.getWaterHeightFromMetadata(world, x, y, z) != 8;
    }

    public boolean isNormal() {
        return false;
    }

    public int getRenderType() {
        return 3;
    }

    public VertexBuffer[] getBlockVertexBufferSided(World world, int x, int y, int z) {
        int height = this.getWaterHeightFromMetadata(world, x, y, z) - 1;
        if (height < 0) {
            return null;
        }
        return ModelLiquid.vertexBuffer[height];
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return AxisAlignedBB.getBoundingBox(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    private int getWaterHeightFromMetadata(World world, int x, int y, int z) {
        if (world == null) {
            return 6;
        }
        return world.getBlockMetadata(x, y, z) >> 4 & 0xF;
    }

    private int getWaterHeightFromWorldAndSide(World world, int x, int y, int z, int side) {
        if (world == null) {
            return 6;
        }
        if (side == 7) {
            return 8;
        }
        if (side == 1) {
            ++z;
        } else if (side == 2) {
            --z;
        } else if (side == 3) {
            ++x;
        } else if (side == 4) {
            --x;
        } else if (side == 5) {
            ++y;
        } else if (side == 6) {
            --y;
        } else {
            return 0;
        }
        if (world.getBlockID(x, y, z) != this.blockID) {
            return 0;
        }
        if (side == 5) {
            return 8;
        }
        int height = this.getWaterHeightFromWorld(world, x, y, z) - this.waterFall;
        if (height < 0) {
            height = 0;
        }
        return height;
    }

    private int getWaterHeightFromWorld(World world, int x, int y, int z) {
        if (world == null) {
            return 6;
        }
        return this.getWaterHeightFromWorldAndSide(world, x, y, z, world.getBlockMetadata(x, y, z) & 0xF);
    }

    private int getWaterMetadataToSaveFromWorld(World world, int x, int y, int z, int side) {
        int waterHeight = this.getWaterHeightFromWorldAndSide(world, x, y, z, side);
        return side | waterHeight << 4;
    }

    private int getWaterMetadataToSaveFromMetadata(World world, int x, int y, int z, int height) {
        int side = world.getBlockMetadata(x, y, z) & 0xF;
        return side | height << 4;
    }

    private int getWaterMetadataToSave(int side, int height) {
        return side | height << 4;
    }

    private int getWaterSide(World world, int x, int y, int z) {
        return world.getBlockMetadata(x, y, z) & 0xF;
    }

    public void tickBlock(World world, int x, int y, int z) {
        if (this.getWaterHeightFromWorld(world, x, y, z) == 0 && this.getWaterHeightFromMetadata(world, x, y, z) > 0) {
            int newHeight = this.getWaterHeightFromMetadata(world, x, y, z) - 3;
            if (newHeight > 0) {
                world.setBlockMetadata(x, y, z, this.getWaterMetadataToSaveFromMetadata(world, x, y, z, newHeight));
            } else {
                world.setBlockID(x, y, z, 0);
            }
            return;
        }
        System.out.println("metadata: " + this.getWaterHeightFromMetadata(world, x, y, z));
        System.out.println("world: " + this.getWaterHeightFromWorld(world, x, y, z));
        if (this.getWaterHeightFromMetadata(world, x, y, z) - this.waterFall == 0) {
            return;
        }
        if (this.getWaterHeightFromMetadata(world, x, y, z) <= 0) {
            world.setBlockID(x, y, z, 0);
            return;
        }
        this.checkForFusion(world, x, y, z);
        if (world.getBlockID(x, y - 1, z) == 0 || world.getBlockID(x, y - 1, z) == this.blockID) {
            world.setBlockAndMetadata(x, y - 1, z, this.blockID, this.getWaterMetadataToSaveFromWorld(world, x, y - 1, z, 5));
        }
        if (world.getBlockID(x, y - 1, z) != 0 && world.getBlockID(x, y - 1, z) != this.blockID) {
            if (world.getBlockID(x - 1, y, z) == 0 || world.getBlockID(x - 1, y, z) == this.blockID && this.getWaterHeightFromMetadata(world, x - 1, y, z) < this.getWaterHeightFromWorld(world, x, y, z) && this.getWaterSide(world, x, y, z) != 4) {
                world.setBlockAndMetadata(x - 1, y, z, this.blockID, this.getWaterMetadataToSaveFromWorld(world, x - 1, y, z, 3));
            }
            if (world.getBlockID(x + 1, y, z) == 0 || world.getBlockID(x + 1, y, z) == this.blockID && this.getWaterHeightFromMetadata(world, x + 1, y, z) < this.getWaterHeightFromWorld(world, x, y, z) && this.getWaterSide(world, x, y, z) != 3) {
                world.setBlockAndMetadata(x + 1, y, z, this.blockID, this.getWaterMetadataToSaveFromWorld(world, x + 1, y, z, 4));
            }
            if (world.getBlockID(x, y, z - 1) == 0 || world.getBlockID(x, y, z - 1) == this.blockID && this.getWaterHeightFromMetadata(world, x, y, z - 1) < this.getWaterHeightFromWorld(world, x, y, z) && this.getWaterSide(world, x, y, z) != 2) {
                world.setBlockAndMetadata(x, y, z - 1, this.blockID, this.getWaterMetadataToSaveFromWorld(world, x, y, z - 1, 1));
            }
            if (world.getBlockID(x, y, z + 1) == 0 || world.getBlockID(x, y, z + 1) == this.blockID && this.getWaterHeightFromMetadata(world, x, y, z + 1) < this.getWaterHeightFromWorld(world, x, y, z) && this.getWaterSide(world, x, y, z) != 1) {
                world.setBlockAndMetadata(x, y, z + 1, this.blockID, this.getWaterMetadataToSaveFromWorld(world, x, y, z + 1, 2));
            }
        }
    }

    private void checkForFusion(World world, int x, int y, int z) {
        Block currentBlock = Block.blocksList[world.getBlockID(x, y, z)];
        Block oppositeBlock = currentBlock == Block.getBlock("water") ? Block.getBlock("lava") : Block.getBlock("water");
        int height = this.getWaterHeightFromMetadata(world, x, y, z);
        if (Block.blocksList[world.getBlockID(x + 1, y, z)] == oppositeBlock && height > 1) {
            if (height < 7) {
                world.setBlockID(x + 1, y, z, Block.getBlock((String)"cobblestone").blockID);
            } else {
                world.setBlockID(x + 1, y, z, Block.getBlock((String)"obsidian").blockID);
            }
        }
        if (Block.blocksList[world.getBlockID(x - 1, y, z)] == oppositeBlock && height > 1) {
            if (height < 7) {
                world.setBlockID(x - 1, y, z, Block.getBlock((String)"cobblestone").blockID);
            } else {
                world.setBlockID(x - 1, y, z, Block.getBlock((String)"obsidian").blockID);
            }
        }
        if (Block.blocksList[world.getBlockID(x, y - 1, z)] == oppositeBlock && height > 1) {
            if (height < 7) {
                world.setBlockID(x, y - 1, z, Block.getBlock((String)"cobblestone").blockID);
            } else {
                world.setBlockID(x, y - 1, z, Block.getBlock((String)"obsidian").blockID);
            }
        }
        if (Block.blocksList[world.getBlockID(x, y, z + 1)] == oppositeBlock && height > 1) {
            if (height < 7) {
                world.setBlockID(x, y, z + 1, Block.getBlock((String)"cobblestone").blockID);
            } else {
                world.setBlockID(x, y, z + 1, Block.getBlock((String)"obsidian").blockID);
            }
        }
        if (Block.blocksList[world.getBlockID(x, y, z - 1)] == oppositeBlock && height > 1) {
            if (height < 7) {
                world.setBlockID(x, y, z - 1, Block.getBlock((String)"cobblestone").blockID);
            } else {
                world.setBlockID(x, y, z - 1, Block.getBlock((String)"obsidian").blockID);
            }
        }
    }

    public void onBlockRemoval(World world, int x, int y, int z) {
        world.getWorldUpdater().removeBlockUpdatable(x, y, z);
    }

    public void onBlockAdded(World world, int x, int y, int z) {
        world.getWorldUpdater().addBlockUpdatable(x, y, z);
    }

    public void onBlockPlaced(World world, int x, int y, int z, int side) {
        world.setBlockMetadata(x, y, z, this.getWaterMetadataToSave(7, 8));
    }

    public boolean canBePieced() {
        return false;
    }
}

