/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.util.Random;
import net.comcraft.src.Block;
import net.comcraft.src.BlockFlower;
import net.comcraft.src.World;

public class BlockTreePlant
extends BlockFlower {
    public BlockTreePlant(int id, int index) {
        super(id, index);
    }

    public void onBlockRemoval(World world, int x, int y, int z) {
        world.getWorldUpdater().removeBlockUpdatable(x, y, z);
    }

    private void setWheatMetadata(World world, int x, int y, int z, int metadata) {
        world.setBlockMetadata(x, y, z, metadata - 128);
    }

    private int getWheatMetadata(World world, int x, int y, int z) {
        return world.getBlockMetadata(x, y, z) + 128;
    }

    public void onBlockAdded(World world, int x, int y, int z) {
        this.setWheatMetadata(world, x, y, z, 0);
        world.getWorldUpdater().addBlockUpdatable(x, y, z);
    }

    public void tickBlock(World world, int x, int y, int z) {
        int currentTick = this.getWheatMetadata(world, x, y, z);
        if (world.isAirBlock(x, y + 1, z) && world.isAirBlock(x, y + 2, z) && world.isAirBlock(x, y + 3, z)) {
            ++currentTick;
        }
        if (currentTick >= 100) {
            world.getWorldUpdater().removeBlockUpdatable(x, y, z);
            this.placeTree(world, x, y, z);
        }
        if (currentTick <= 255) {
            this.setWheatMetadata(world, x, y, z, currentTick);
        }
    }

    private void placeTree(World world, int x, int y, int z) {
        world.setBlockID(x, y, z, Block.getBlock((String)"wood").blockID);
        int n = 1;
        while (n <= 3) {
            if (!world.isAirBlock(x, y + n, z)) {
                return;
            }
            world.setBlockID(x, y + n, z, Block.getBlock((String)"wood").blockID);
            ++n;
        }
        Random random = new Random();
        int n2 = 2;
        while (n2 <= 5) {
            int b = -1;
            while (b <= 1) {
                int a = -1;
                while (a <= 1) {
                    if (world.isAirBlock(x + a, y + n2, z + b) && random.nextInt(6 - n2) != 0) {
                        world.setBlockID(x + a, y + n2, z + b, Block.getBlock((String)"leaves").blockID);
                    }
                    ++a;
                }
                ++b;
            }
            ++n2;
        }
        world.setBlockID(x, y + 4, z, Block.getBlock((String)"leaves").blockID);
    }

    public boolean isUpdatableBlock() {
        return true;
    }
}

