/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import net.comcraft.client.Comcraft;
import net.comcraft.src.Keyboard;
import net.comcraft.src.Touch;

public class InputManager {
    private Comcraft cc;
    private float touchSensitivity;

    public InputManager(Comcraft cc) {
        this.cc = cc;
        this.touchSensitivity = 1.0f / (float)(Comcraft.screenHeight / 80);
    }

    private void handleTouchInput() {
        if (Touch.isInputHandled()) {
            return;
        }
        if (Touch.isDragged()) {
            this.rotatePlayerTouch(Touch.getTouchXDifference(), Touch.getTouchYDifference());
        } else if (Touch.isPressed() && Touch.getTouchPressDtTime(this.cc.currentTime) > 800 && Touch.getNextEvent() != 2) {
            this.cc.onClick(0, this.cc.player.rayTrace(this.cc.playerManager.getBlockReachDistance(), Touch.getX(), Touch.getY()));
            Touch.resetTouch();
        } else if (Touch.wasPressed() && !Touch.wasDragged() && Touch.getTouchPressDtTime(this.cc.currentTime) <= 800) {
            this.cc.onClick(1, this.cc.player.rayTrace(this.cc.playerManager.getBlockReachDistance(), Touch.getX(), Touch.getY()));
            Touch.resetTouch();
        }
    }

    private void rotatePlayerTouch(int xDifference, int yDifference) {
        this.cc.player.rotate((float)xDifference * this.touchSensitivity, (float)yDifference * this.touchSensitivity);
    }

    private void rotatePlayerKeyboard(int rotationPitch, int rotationYaw) {
        float dt = this.cc.dt;
        if (dt > 0.3f) {
            dt = 0.3f;
        }
        float rotation = 45.0f * dt;
        this.cc.player.rotate(rotation * (float)rotationPitch, rotation * (float)rotationYaw);
    }

    private void handleKeyboardInput() {
        if (Keyboard.isButtonDown(-2) || Keyboard.isButtonDown(107)) {
            this.rotatePlayerKeyboard(-1, 0);
        } else if (Keyboard.isButtonDown(-1) || Keyboard.isButtonDown(105)) {
            this.rotatePlayerKeyboard(1, 0);
        } else if (Keyboard.isButtonDown(-3) || Keyboard.isButtonDown(106)) {
            this.rotatePlayerKeyboard(0, -1);
        } else if (Keyboard.isButtonDown(-4) || Keyboard.isButtonDown(108)) {
            this.rotatePlayerKeyboard(0, 1);
        } else if (Keyboard.isButtonDown(50) || Keyboard.isButtonDown(119)) {
            this.cc.player.moveEntity(0, 0, -1);
        } else if (Keyboard.isButtonDown(56) || Keyboard.isButtonDown(115)) {
            this.cc.player.moveEntity(0, 0, 1);
        } else if (Keyboard.isButtonDown(52) || Keyboard.isButtonDown(97)) {
            this.cc.player.moveEntity(1, 0, 0);
        } else if (Keyboard.isButtonDown(54) || Keyboard.isButtonDown(100)) {
            this.cc.player.moveEntity(-1, 0, 0);
        } else if (Keyboard.isButtonDown(49) || Keyboard.isButtonDown(113)) {
            this.cc.player.moveEntity(0, 1, 0);
        } else if (Keyboard.isButtonDown(51) || Keyboard.isButtonDown(101)) {
            this.cc.player.moveEntity(0, -1, 0);
        } else if ((!Keyboard.isButtonDown(53) && Keyboard.wasButtonDown(53) || !Keyboard.isButtonDown(102) && Keyboard.wasButtonDown(102) || !Keyboard.isButtonDown(-5) && Keyboard.wasButtonDown(-5)) && Keyboard.getButtonPressDtTime(this.cc.currentTime) <= 400) {
            this.cc.onClick(1, this.cc.player.rayTrace(this.cc.playerManager.getBlockReachDistance()));
            Keyboard.resetKeyboard();
        } else if ((Keyboard.isButtonDown(53) || Keyboard.isButtonDown(102) || Keyboard.isButtonDown(-5)) && Keyboard.getButtonPressDtTime(this.cc.currentTime) > 400) {
            this.cc.onClick(0, this.cc.player.rayTrace(this.cc.playerManager.getBlockReachDistance()));
            Keyboard.resetKeyboard();
        } else if (Keyboard.wasButtonDown(48) || Keyboard.wasButtonDown(116)) {
            this.cc.endWorld();
        } else if (Keyboard.wasButtonDown(55) || Keyboard.wasButtonDown(117)) {
            if (this.cc.player.inventory.getSelectedElementNum() > 0) {
                this.cc.player.inventory.setSelectedElement(this.cc.player.inventory.getSelectedElementNum() - 1);
            } else {
                this.cc.player.inventory.setSelectedElement(this.cc.player.inventory.getFastSlotSize() - 1);
            }
        } else if (Keyboard.wasButtonDown(57) || Keyboard.wasButtonDown(111)) {
            if (this.cc.player.inventory.getSelectedElementNum() < this.cc.player.inventory.getFastSlotSize() - 1) {
                this.cc.player.inventory.setSelectedElement(this.cc.player.inventory.getSelectedElementNum() + 1);
            } else {
                this.cc.player.inventory.setSelectedElement(0);
            }
        }
    }

    public void handleInput() {
        if (this.cc.world == null || this.cc.currentScreen != null) {
            return;
        }
        this.handleKeyboardInput();
        this.handleTouchInput();
    }
}

