/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

public class MathHelper {
    static final double sq2p1 = 2.414213562373095;
    static final double sq2m1 = 0.41421356237309503;
    static final double p4 = 16.15364129822302;
    static final double p3 = 268.42548195503974;
    static final double p2 = 1153.029351540485;
    static final double p1 = 1780.406316433197;
    static final double p0 = 896.7859740366387;
    static final double q4 = 58.95697050844462;
    static final double q3 = 536.2653740312153;
    static final double q2 = 1666.7838148816338;
    static final double q1 = 2079.33497444541;
    static final double q0 = 896.7859740366387;
    static final double PIO2 = 1.5707963267948966;
    static final double nan = Double.NaN;

    public static boolean isOpositeSign(float a, float b) {
        return a < 0.0f && b > 0.0f || a > 0.0f && b < 0.0f;
    }

    public static double getRadians(int x, int y) {
        if (x == 0) {
            if (y > 0) {
                return 1.5707963267948966;
            }
            if (y < 0) {
                return -1.5707963267948966;
            }
            return 0.0;
        }
        return MathHelper.atan(y / x) + (x < 0 ? Math.PI : 0.0);
    }

    private static double mxatan(double arg) {
        double argsq = arg * arg;
        double value = (((16.15364129822302 * argsq + 268.42548195503974) * argsq + 1153.029351540485) * argsq + 1780.406316433197) * argsq + 896.7859740366387;
        return (value /= ((((argsq + 58.95697050844462) * argsq + 536.2653740312153) * argsq + 1666.7838148816338) * argsq + 2079.33497444541) * argsq + 896.7859740366387) * arg;
    }

    private static double msatan(double arg) {
        if (arg < 0.41421356237309503) {
            return MathHelper.mxatan(arg);
        }
        if (arg > 2.414213562373095) {
            return 1.5707963267948966 - MathHelper.mxatan(1.0 / arg);
        }
        return 0.7853981633974483 + MathHelper.mxatan((arg - 1.0) / (arg + 1.0));
    }

    public static double atan(double arg) {
        if (arg > 0.0) {
            return MathHelper.msatan(arg);
        }
        return -MathHelper.msatan(-arg);
    }

    public static double atan2(double arg1, double arg2) {
        if (arg1 + arg2 == arg1) {
            if (arg1 >= 0.0) {
                return 1.5707963267948966;
            }
            return -1.5707963267948966;
        }
        arg1 = MathHelper.atan(arg1 / arg2);
        if (arg2 < 0.0) {
            if (arg1 <= 0.0) {
                return arg1 + Math.PI;
            }
            return arg1 - Math.PI;
        }
        return arg1;
    }

    public static double asin(double arg) {
        int sign = 0;
        if (arg < 0.0) {
            arg = -arg;
            ++sign;
        }
        if (arg > 1.0) {
            return Double.NaN;
        }
        double temp = Math.sqrt(1.0 - arg * arg);
        temp = arg > 0.7 ? 1.5707963267948966 - MathHelper.atan(temp / arg) : MathHelper.atan(arg / temp);
        if (sign > 0) {
            temp = -temp;
        }
        return temp;
    }

    public static double acos(double arg) {
        if (arg > 1.0 || arg < -1.0) {
            return Double.NaN;
        }
        return 1.5707963267948966 - MathHelper.asin(arg);
    }

    public static double pow(double x, double y) {
        return MathHelper.powTaylor(x, y);
    }

    public static double powSqrt(double x, double y) {
        int i;
        int den = 1024;
        int num = (int)(y * (double)den);
        int iterations = 10;
        double n = Double.MAX_VALUE;
        while (n >= Double.MAX_VALUE && iterations > 1) {
            n = x;
            i = 1;
            while (i < num) {
                n *= x;
                ++i;
            }
            if (!(n >= Double.MAX_VALUE)) continue;
            --iterations;
            num = (int)(y * (double)(den /= 2));
        }
        i = 0;
        while (i < iterations) {
            n = Math.sqrt(n);
            ++i;
        }
        return n;
    }

    public static double powDecay(double x, double y) {
        int den = 1001;
        int s = 0;
        double n = x;
        double z = Double.MAX_VALUE;
        int i = 1;
        while (i < s) {
            n *= x;
            ++i;
        }
        while (z >= Double.MAX_VALUE) {
            int num = (int)(y * (double)(--den));
            s = num / den + 1;
            z = x;
            i = 1;
            while (i < num) {
                z *= x;
                ++i;
            }
        }
        while (n > 0.0) {
            double a = n;
            int i2 = 1;
            while (i2 < den) {
                a *= n;
                ++i2;
            }
            if (a - z < 1.0E-5 || z - a > 1.0E-5) {
                return n;
            }
            n *= 0.9999;
        }
        return -1.0;
    }

    public static double powTaylor(double a, double b) {
        boolean gt1 = !(Math.sqrt((a - 1.0) * (a - 1.0)) <= 1.0);
        int oc = -1;
        int iter = 30;
        double p = a;
        if (b - Math.floor(b) == 0.0) {
            int i = 1;
            while ((double)i < b) {
                p *= a;
                ++i;
            }
            return p;
        }
        double x = gt1 ? a / (a - 1.0) : a - 1.0;
        double sumX = gt1 ? 1.0 / x : x;
        int i = 2;
        while (i < iter) {
            p = x;
            int j = 1;
            while (j < i) {
                p *= x;
                ++j;
            }
            double xTemp = gt1 ? 1.0 / ((double)i * p) : p / (double)i;
            sumX = gt1 ? sumX + xTemp : sumX + xTemp * (double)oc;
            oc *= -1;
            ++i;
        }
        double x2 = b * sumX;
        double sumY = 1.0 + x2;
        i = 2;
        while (i <= iter) {
            p = x2;
            int j = 1;
            while (j < i) {
                p *= x2;
                ++j;
            }
            int yTemp = 2;
            int j2 = i;
            while (j2 > 2) {
                yTemp *= j2;
                --j2;
            }
            sumY += p / (double)yTemp;
            ++i;
        }
        return sumY;
    }
}

