/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import com.google.minijoe.sys.JsArray;
import com.google.minijoe.sys.JsException;
import com.google.minijoe.sys.JsFunction;
import com.google.minijoe.sys.JsObject;
import com.google.minijoe.sys.JsObjectFactory;
import com.google.minijoe.sys.JsSystem;
import com.simon816.minijoe.nativetypes.Transform;
import net.comcraft.client.Comcraft;
import net.comcraft.src.AxisAlignedBB;
import net.comcraft.src.Block;
import net.comcraft.src.DebugConsole;
import net.comcraft.src.EventHandlerAPI;
import net.comcraft.src.GuiButton;
import net.comcraft.src.InvItemStack;
import net.comcraft.src.ModelsList;
import net.comcraft.src.Vec3D;

public class ModAPI
extends JsObject
implements JsObjectFactory {
    private static final int ID_IMPORT = 1000;
    private static final int FACTORY_ID_VEC3D = 0;
    private static final int FACTORY_ID_AABB = 1;
    private static final int FACTORY_ID_INVITEMSTACK = 2;
    private static final int FACTORY_ID_BLOCK = 3;
    private static final int FACTORY_ID_TRANSFORM = 4;
    private static final int FACTORY_ID_GUIBUTTON = 5;
    private static ModAPI instance = null;
    public static final EventHandlerAPI event = new EventHandlerAPI();
    private Comcraft cc;

    public static ModAPI getInstance(Comcraft cc) {
        if (instance == null) {
            instance = new ModAPI(cc);
        }
        return instance;
    }

    public static ModAPI getInstance() {
        if (instance == null) {
            throw new NullPointerException("First instance of ModAPI must provide net.comcraft.client.Comcraft instance");
        }
        return instance;
    }

    private ModAPI(Comcraft cc) {
        super(JsObject.OBJECT_PROTOTYPE);
        this.cc = cc;
        this.scopeChain = JsSystem.createGlobal();
        this.addSingletonObjects();
        this.addFunctions();
        this.addInstantiableObjects();
        this.addEventHandlerEvents();
    }

    private void addSingletonObjects() {
        this.addVar("console", new DebugConsole());
        this.addVar("EventHandler", event);
        this.addVar("Model", new ModelsList());
    }

    private void addFunctions() {
        this.addNative("importFile", 1000, 2);
    }

    private void addInstantiableObjects() {
        this.addVar("AxisAlignedBB", new JsFunction(this, 1, AxisAlignedBB.AABB_PROTOTYPE, 102, 6));
        this.addVar("Vec3D", new JsFunction(this, 0, Vec3D.VEC3D_PROTOTYPE, 111, 3));
        this.addVar("InvItemStack", new JsFunction(this, 2, InvItemStack.ITEMSTACK_PROTOTYPE, 103, 2));
        this.addVar("Block", new JsFunction(this, 3, Block.BLOCK_PROTOTYPE, 100, 2));
        this.addVar("Transform", new JsFunction(this, 4, Transform.TRANSFORM_PROTOTYPE, 100, 0));
        this.addVar("GuiButton", new JsFunction(this, 5, GuiButton.GUIBUTTON_PROTOTYPE, 100, 3));
    }

    private void addEventHandlerEvents() {
        event.addEvent("World.Generate");
        event.addEvent("Render.Init");
        event.addEvent("Game.Command");
        event.addEvent("Language.List");
        event.addEvent("Comcraft.displayScreen");
        event.addEvent("Player.Construct");
        event.addEvent("Game.Player.moveEntity");
        event.addEvent("Game.Player.updateEntityMove");
    }

    public void evalNative(int id, JsArray stack, int sp, int parCount) {
        if (id < 1000 && id >= 100) {
            throw new IllegalArgumentException("Invalid function call. You may have missed the 'new' keyword");
        }
        switch (id) {
            case 1000: {
                if (parCount < 2) {
                    throw new JsException((Object)"Not enough parameters to importFile");
                }
                String pkg = stack.getString(sp + 2);
                String file = stack.getString(sp + 3);
                try {
                    stack.setBoolean(sp, this.cc.modLoader.executeModInNs(pkg, file));
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new JsException((Object)("Import " + pkg + "." + file + " failed: " + e.getMessage()));
                }
            }
            default: {
                super.evalNative(id, stack, sp, parCount);
            }
        }
    }

    public JsObject newInstance(int type) {
        switch (type) {
            case 0: {
                return new Vec3D();
            }
            case 1: {
                return new AxisAlignedBB(AxisAlignedBB.AABB_PROTOTYPE);
            }
            case 2: {
                return new InvItemStack();
            }
            case 3: {
                return new Block(Block.BLOCK_PROTOTYPE);
            }
            case 4: {
                return new Transform(Transform.TRANSFORM_PROTOTYPE);
            }
            case 5: {
                return new GuiButton(this.cc);
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return "[object ModAPI]";
    }
}

