/*
 * Decompiled with CFR 0.152.
 */
package Coral.Audio;

import Coral.Util.crlBinArray;
import Coral.Util.crlManagerBase;
import Coral.Util.crlResourceManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class crlAudioManager
extends crlManagerBase {
    static final int MBOOSTER_MAX_INSTANCES = 1;
    public static final int INFINITE_LOOP = -1;
    public static final int VOLUME_FULL = 100;
    public static final int VOLUME_HALF = 50;
    public static final int VOLUME_OFF = 0;
    public static final int NO_SOUND = -1;
    public static final int[] VOLUME_LEVEL = new int[]{0, 25, 50, 100};
    private static final String[] _AUDIO_TYPE = new String[]{"audio/amr", "audio/midi", "audio/mpeg", "audio/x-wav", "Nokia tone format"};
    protected static int _gGlobalVolume;
    private crlResourceManager _mResManager;
    protected Player[] _mPlayer;
    private int[] _mPlayerState;
    private crlBinArray[] _mPlayerData;
    private int[] _mPlayerType;
    private int[] _mPlayerLoop;
    protected int _mNumPlayers;
    private int[] _mLoadedPlayers;
    private int[] _mPrefetchedPlayers;
    private int _mRequestedSound;
    private boolean forceStop = true;
    public static int mAudioState;
    private int _mChannelDividerIndex;
    private static final int _VIBRATION_ON = 500;
    private static final int _VIBRATION_OFF = 0;
    private Display _mDisplay;
    private int _mVibrateTimer;
    private boolean _mVibrating;
    private int _mVibrationUnit;

    public static boolean isSupported(int n) {
        boolean bl = false;
        String[] stringArray = Manager.getSupportedContentTypes(null);
        for (int i = 0; i < stringArray.length && !bl; ++i) {
            bl = stringArray[i].equals(_AUDIO_TYPE[n]);
        }
        return bl;
    }

    public crlAudioManager() {
        this._mStatus = 0;
    }

    public int open() {
        return -1;
    }

    public final int open(crlResourceManager crlResourceManager2, int n) {
        return this.open(crlResourceManager2, n, 0, n);
    }

    public int open(crlResourceManager crlResourceManager2, int n, int n2, int n3) {
        int n4;
        this._mPlayer = new Player[n];
        this._mPlayerState = new int[n];
        for (n4 = 0; n4 < this._mPlayerState.length; ++n4) {
            this._mPlayerState[n4] = 7;
        }
        this._mPlayerData = new crlBinArray[n];
        this._mPlayerType = new int[n];
        this._mPlayerLoop = new int[n];
        if (n3 >= n) {
            n2 = 0;
            n3 = n;
        } else if (n2 == 1) {
            n2 = 2;
        }
        if (n3 <= 0) {
            n3 = 1;
        }
        this._mLoadedPlayers = new int[n2];
        for (n4 = 0; n4 < n2; ++n4) {
            this._mLoadedPlayers[n4] = -1;
        }
        this._mPrefetchedPlayers = new int[n3];
        for (n4 = 0; n4 < n3; ++n4) {
            this._mPrefetchedPlayers[n4] = -1;
        }
        this._mResManager = crlResourceManager2;
        this._mStatus = 4;
        this._mNumPlayers = 0;
        _gGlobalVolume = 100;
        return 0;
    }

    public int close() {
        this.removeAudioBank();
        this._mPlayer = null;
        this._mPlayerState = null;
        this._mPlayerData = null;
        this._mPlayerType = null;
        this._mPlayerLoop = null;
        this._mStatus = 0;
        return 0;
    }

    public int update() {
        switch (this._mStatus) {
            case 7: {
                break;
            }
            case 2: {
                if (this._mRequestedSound != -1) {
                    try {
                        if (this._mLoadedPlayers.length > 0 && !this._isLoaded(this._mRequestedSound)) {
                            int n = this._mLoadedPlayers[this._mLoadedPlayers.length - 1];
                            if (this._isLoaded(n)) {
                                if (this._mPlayerState[n] != 0) {
                                    this._unloadPlayer(n);
                                }
                            } else {
                                this._mLoadedPlayers[this._mLoadedPlayers.length - 1] = -1;
                                if (this._loadPlayer(this._mRequestedSound) == 0) {
                                    this._sortArray(this._mLoadedPlayers, this._mRequestedSound, 0);
                                }
                            }
                        } else if (!this._isPrefetched(this._mRequestedSound)) {
                            int n = this._mPrefetchedPlayers[this._mPrefetchedPlayers.length - 1];
                            if (this._isPrefetched(n)) {
                                if (this._mPlayerState[n] != 5 && this._mPlayerState[n] != 0) {
                                    if (this._mLoadedPlayers.length == 0) {
                                        this._killPlayer(n);
                                    } else {
                                        int n2 = this._mLoadedPlayers[this._mLoadedPlayers.length - 1];
                                        if (this._isLoaded(n2)) {
                                            if (this._mPlayerState[n2] != 0) {
                                                this._unloadPlayer(n2);
                                            }
                                        } else {
                                            this._mLoadedPlayers[this._mLoadedPlayers.length - 1] = -1;
                                            if (this._deallocatePlayer(n) == 0) {
                                                this._sortArray(this._mLoadedPlayers, n, 0);
                                            }
                                        }
                                    }
                                }
                            } else if (this._prefetchPlayer(this._mRequestedSound) == 0) {
                                this._sortArray(this._mPrefetchedPlayers, this._mRequestedSound, 0);
                                this._sortArray(this._mLoadedPlayers, this._mRequestedSound, 1);
                            }
                        } else {
                            boolean bl = true;
                            for (int i = this._getFirstIndex(this._mRequestedSound); i <= this._getLastIndex(this._mRequestedSound) && bl; ++i) {
                                if (this._mPlayerState[i] == 8) {
                                    if (!this._isStopped(i)) {
                                        if (this.forceStop) {
                                            this._stopPlayer(i);
                                        }
                                    } else {
                                        this._mPlayerState[i] = 2;
                                    }
                                    bl = false;
                                    continue;
                                }
                                if (this._mPlayerState[i] != 11) continue;
                                if (this._isStopped(i)) {
                                    this._mPlayerState[i] = 2;
                                    continue;
                                }
                                bl = false;
                            }
                            if (bl && this._startPlayer(this._mRequestedSound) == 0) {
                                if (this._mPrefetchedPlayers.length < this._mNumPlayers && this._mPrefetchedPlayers[0] != this._mRequestedSound) {
                                    this._sortArray(this._mPrefetchedPlayers, this._mRequestedSound, 0);
                                }
                                this._mRequestedSound = -1;
                            }
                        }
                    }
                    catch (Exception exception) {
                        this._mRequestedSound = -1;
                    }
                }
                if (this._mVibrationUnit == 1) {
                    if (this._mVibrateTimer <= 0) break;
                    --this._mVibrateTimer;
                    if (this._mVibrating && this._mVibrateTimer == 0) {
                        this.stopVibrations();
                        break;
                    }
                    this.startVibrations(500);
                    break;
                }
                if (this._mVibrationUnit != 0 || this._mVibrateTimer <= 0) break;
                this.startVibrations(this._mVibrateTimer);
                this._mVibrateTimer = 0;
                break;
            }
            case 6: {
                break;
            }
            case 3: {
                this._pause();
                this.stopVibrations();
                this._mStatus = 4;
                break;
            }
        }
        return 0;
    }

    private int _getFirstIndex(int n) {
        if (n >= this._mChannelDividerIndex) {
            return this._mChannelDividerIndex;
        }
        return 0;
    }

    private int _getLastIndex(int n) {
        if (n < this._mChannelDividerIndex) {
            return this._mChannelDividerIndex - 1;
        }
        return this._mNumPlayers - 1;
    }

    private void _sortArray(int[] nArray, int n, int n2) {
        try {
            if (nArray.length > 0) {
                if (n2 == 0) {
                    int n3 = -1;
                    int n4 = n;
                    for (int i = 0; i < nArray.length && n3 != n; ++i) {
                        n3 = nArray[i];
                        nArray[i] = n4;
                        n4 = n3;
                    }
                } else if (n2 == 1) {
                    boolean bl = false;
                    if (nArray[nArray.length - 1] == n) {
                        bl = true;
                    } else {
                        for (int i = 0; i < nArray.length - 1; ++i) {
                            if (nArray[i] == n) {
                                bl = true;
                            }
                            if (!bl) continue;
                            nArray[i] = nArray[i + 1];
                        }
                    }
                    if (bl) {
                        nArray[nArray.length - 1] = -1;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setForceStop(boolean bl) {
        this.forceStop = bl;
    }

    public boolean isStarted(int n) {
        return !this._isStopped(n);
    }

    public int loadAudioBank(long[] lArray, int n) {
        int n2 = this.loadAudioBank(lArray);
        if (this._mPrefetchedPlayers.length > 2 && n < this._mNumPlayers) {
            this._mChannelDividerIndex = n;
        }
        return n2;
    }

    public int loadAudioBank(String[] stringArray, int[] nArray, int n) {
        int n2 = this.loadAudioBank(stringArray, nArray);
        if (this._mPrefetchedPlayers.length > 2 && n < this._mNumPlayers) {
            this._mChannelDividerIndex = n;
        }
        return n2;
    }

    public int loadAudioBank(long[] lArray) {
        int n;
        int n2 = 0;
        if (this._mNumPlayers != 0) {
            this.removeAudioBank();
        }
        for (n = 0; n < lArray.length && n2 < this._mPlayerType.length; ++n2, n += 2) {
            this._mPlayerType[n2] = (int)lArray[n + 1];
            this._mPlayerData[n2] = this._mResManager.getBinBySpongeID(lArray[n]);
        }
        this._mRequestedSound = -1;
        for (n = 0; n < this._mPrefetchedPlayers.length; ++n) {
            this._mPrefetchedPlayers[n] = -1;
        }
        for (n = 0; n < this._mPrefetchedPlayers.length && n < n2; ++n) {
            if (this._prefetchPlayer(n) != -1) continue;
            this._mPrefetchedPlayers[n] = n;
        }
        for (n = 0; n < this._mLoadedPlayers.length; ++n) {
            this._mLoadedPlayers[n] = -1;
        }
        for (n = this._mPrefetchedPlayers.length; n - this._mPrefetchedPlayers.length < this._mLoadedPlayers.length && n < n2; ++n) {
            if (this._loadPlayer(n) != -1) continue;
            this._mLoadedPlayers[n - this._mPrefetchedPlayers.length] = n;
        }
        this._mNumPlayers = n2;
        this._mChannelDividerIndex = n2;
        return 0;
    }

    public int loadAudioBank(String[] stringArray, int[] nArray) {
        int n;
        int n2 = 0;
        if (this._mNumPlayers != 0) {
            this.removeAudioBank();
        }
        for (n = 0; n < stringArray.length && n2 < this._mPlayerType.length; ++n) {
            try {
                this._mPlayerType[n2] = nArray[n];
                InputStream inputStream = this.getClass().getResourceAsStream(stringArray[n]);
                crlBinArray crlBinArray2 = new crlBinArray();
                byte[] byArray = new byte[inputStream.available()];
                inputStream.read(byArray, 0, byArray.length);
                inputStream.close();
                crlBinArray2.set(byArray, 0, byArray.length);
                this._mPlayerData[n2] = crlBinArray2;
                ++n2;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._mRequestedSound = -1;
        for (n = 0; n < this._mPrefetchedPlayers.length; ++n) {
            this._mPrefetchedPlayers[n] = -1;
        }
        for (n = 0; n < this._mPrefetchedPlayers.length && n < n2; ++n) {
            if (this._prefetchPlayer(n) == -1) {
                return -1;
            }
            this._mPrefetchedPlayers[n] = n;
        }
        for (n = 0; n < this._mLoadedPlayers.length; ++n) {
            this._mLoadedPlayers[n] = -1;
        }
        for (n = this._mPrefetchedPlayers.length; n - this._mPrefetchedPlayers.length < this._mLoadedPlayers.length && n < n2; ++n) {
            if (this._loadPlayer(n) == -1) {
                return -1;
            }
            this._mLoadedPlayers[n - this._mPrefetchedPlayers.length] = n;
        }
        this._mNumPlayers = n2;
        return 0;
    }

    public int removeAudioBank(int n) {
        return this.removeAudioBank();
    }

    public int removeAudioBank() {
        for (int i = 0; i < this._mNumPlayers; ++i) {
            this._killPlayer(i);
            this._mPlayerType[i] = -1;
            this._mPlayerData[i] = null;
        }
        this._mNumPlayers = 0;
        this._mChannelDividerIndex = 0;
        return 0;
    }

    public void stopAllAudio() {
        for (int i = 0; i < this._mNumPlayers; ++i) {
            if (this._isStopped(i) && this._mPlayerState[i] != 8 && this._mPlayerState[i] != 9) continue;
            this._stopPlayer(i);
            if (this._mPlayerState[i] != 9) continue;
            this._mPlayerState[i] = 2;
        }
        this._mRequestedSound = -1;
    }

    public void stopAudio(int n) {
        if (n < 0 || n >= this._mNumPlayers) {
            return;
        }
        this._stopPlayer(n);
        if (this._mPlayerState[n] == 9) {
            this._mPlayerState[n] = 2;
        }
    }

    public void pauseAudio() {
        if (this._mStatus == 2) {
            this._pause();
            this.stopVibrations();
            this._mStatus = 4;
            this._mRequestedSound = -1;
        }
    }

    public void resumeAudio() {
        if (this._mStatus == 4) {
            this._mStatus = 2;
            this._resume();
        }
    }

    public void playAudio(int n, int n2) {
        this.playAudio(n, _gGlobalVolume, n2);
    }

    public void playAudio(int n, int n2, int n3) {
        if (this._mNumPlayers == 0) {
            return;
        }
        this._mStatus = 2;
        if (n > -1 && n < this._mNumPlayers) {
            this._mPlayerLoop[n] = n3;
            this._mRequestedSound = n;
        }
    }

    public void setGlobalVolume(int n) {
        if (n <= 100 && n >= 0) {
            _gGlobalVolume = n;
        }
    }

    public static int getAudioVolume() {
        return _gGlobalVolume;
    }

    private boolean _isLoaded(int n) {
        return n != -1 && n < this._mNumPlayers && this._mPlayer[n] != null;
    }

    private boolean _isPrefetched(int n) {
        return n != -1 && n < this._mNumPlayers && this._mPlayer[n] != null && this._mPlayer[n].getState() >= 300;
    }

    private boolean _isStopped(int n) {
        return n == -1 || n >= this._mNumPlayers || this._mPlayer[n] == null || (this._mPlayerState[n] != 8 || this._mPlayerLoop[n] != -1) && this._mPlayer[n].getState() != 400;
    }

    private int _loadPlayer(int n) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this._mPlayerData[n].getArray(), this._mPlayerData[n].getOffset(), this._mPlayerData[n].getLength());
            this._mPlayer[n] = Manager.createPlayer((InputStream)byteArrayInputStream, (String)_AUDIO_TYPE[this._mPlayerType[n]]);
            this._mPlayer[n].realize();
            this._mPlayerState[n] = 1;
            byteArrayInputStream.close();
            byteArrayInputStream = null;
        }
        catch (Exception exception) {
            this._mRequestedSound = -1;
            return -1;
        }
        return 0;
    }

    private int _prefetchPlayer(int n) {
        if (!this._isLoaded(n) && this._loadPlayer(n) == -1) {
            return -1;
        }
        try {
            this._mPlayer[n].prefetch();
            this._mPlayerState[n] = 2;
        }
        catch (Exception exception) {
            this._mRequestedSound = -1;
            return -1;
        }
        return 0;
    }

    private int _startPlayer(int n) {
        if (!this._isStopped(n)) {
            this._mPlayerState[n] = 8;
            return -1;
        }
        try {
            Thread.yield();
            this._mPlayer[n].setLoopCount(this._mPlayerLoop[n]);
            this._mPlayer[n].start();
            this._mPlayerState[n] = 8;
        }
        catch (Exception exception) {
            return -1;
        }
        return 0;
    }

    private int _pause() {
        for (int i = 0; i < this._mNumPlayers; ++i) {
            if (!this._isPrefetched(i) || this._mPlayerState[i] != 8 && this._isStopped(i)) continue;
            if (this._isStopped(i)) {
                this._mPlayerState[i] = 2;
                continue;
            }
            this._stopPlayer(i);
            if (this._mPlayerLoop[i] != -1) continue;
            this._mPlayerState[i] = 9;
        }
        return 0;
    }

    private int _resume() {
        for (int i = 0; i < this._mNumPlayers; ++i) {
            if (this._mPlayerState[i] != 9) continue;
            this._mPlayerState[i] = 2;
            this._mRequestedSound = i;
        }
        return 0;
    }

    private int _stopPlayer(int n) {
        try {
            this._mPlayer[n].stop();
            this._mPlayerState[n] = !this._isStopped(n) ? 11 : 2;
        }
        catch (Exception exception) {
            return -1;
        }
        return 0;
    }

    private int _killPlayer(int n) {
        if (this._deallocatePlayer(n) == 0) {
            return this._unloadPlayer(n);
        }
        return -1;
    }

    private int _deallocatePlayer(int n) {
        if (this._isPrefetched(n)) {
            try {
                this._mPlayer[n].stop();
                this._mPlayer[n].deallocate();
                this._mPlayerState[n] = 5;
            }
            catch (Exception exception) {
                return this._unloadPlayer(n);
            }
        }
        return 0;
    }

    private int _unloadPlayer(int n) {
        if (this._isLoaded(n)) {
            try {
                this._mPlayer[n].close();
                this._mPlayer[n] = null;
                this._mPlayerState[n] = 0;
            }
            catch (Exception exception) {
                return -1;
            }
        }
        return 0;
    }

    public int open(crlResourceManager crlResourceManager2, int n, Display display) {
        this._mDisplay = display;
        return this.open(crlResourceManager2, n);
    }

    public int open(crlResourceManager crlResourceManager2, int n, int n2, int n3, Display display) {
        this._mDisplay = display;
        return this.open(crlResourceManager2, n, n2, n3);
    }

    public boolean isVibrationSupported() {
        return this._mDisplay != null && this._mDisplay.vibrate(0);
    }

    public void vibrate(int n) {
        this._mStatus = 2;
        this._mVibrateTimer += n;
    }

    private void startVibrations(int n) {
        try {
            this._mDisplay.vibrate(n);
            this._mVibrating = n > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopVibrations() {
        try {
            this._mDisplay.vibrate(0);
            this._mVibrateTimer = 0;
            this._mVibrating = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void setVibrationUnitType(int n) {
        this._mVibrationUnit = n;
    }

    public String report(int n) {
        return null;
    }

    public static interface iVibrationUnitType {
        public static final int TIME_MS = 0;
        public static final int FRAMES = 1;
    }

    private static interface _iSortAction {
        public static final int PLACE_FIRST = 0;
        public static final int REMOVE = 1;
    }

    public static interface mAudioStatus
    extends crlManagerBase.mngrStatus {
        public static final int STANDBY = 7;
        public static final int LOOPING = 8;
        public static final int PAUSED = 9;
        public static final int ERROR = 10;
        public static final int STOPPING = 11;
        public static final int PLAYING = 8;
    }

    public static interface mAudioType {
        public static final int AMR = 0;
        public static final int MIDI = 1;
        public static final int MP3 = 2;
        public static final int XWAV = 3;
        public static final int FORMAT_TONE = 4;
        public static final int TOTAL = 5;
    }

    public static interface iVolume {
        public static final int OFF = 0;
        public static final int QUARTER = 1;
        public static final int HALF = 2;
        public static final int FULL = 3;
    }
}

